
%finds all images, creates the bubble and calculates the error
function bmApp()
	config = getConfig(); 
	imagesDir = config.('imagesDir'); 
	tempDir_l = config.('moveToDir_l');
	tempDir_b = config.('moveToDir_b');
	saveInDir = config.('saveInDir'); 
	saveBubblePrefix = config.('saveBubblePrefix'); 
	saveErrorPrefix = config.('saveErrorPrefix'); 
	saveDataString = '';
	saveResultsTo = config.('saveResults'); 
	
	mask_mm = str2num(config.('mask_mm')); 
	deg_from_zero = str2num(config.('deg_from_zero')); 
	mm_from_zero = str2num(config.('mm_from_zero')); 
	tolerance = str2num(config.('tolerance')); 
	
	directory = dir(imagesDir);
	images = []; 
	
	%get images names
	for i=1:length(directory)
		if ~directory(i).isdir
			images = [images; string(directory(i).name)]; 
		end
	end
	
	%prelucreaza imaginile
	for i = 1:length(images)
		imgName = strcat(imagesDir, images(i)); 
		saveName_l = strcat(saveInDir, saveBubblePrefix, images(i)); 
		moveName_l = strcat(tempDir_l, images(i)); 
		saveName_b = strcat(saveInDir, saveErrorPrefix, saveBubblePrefix, images(i)); 
		
		bubble = findBubble(imgName);
		imwrite(bubble, saveName_l); 
		%figure; imshow(bubble);
		movefile(imgName, moveName_l); 
		
		
		[distance_degrees, distance_mm, distance_pix, center] = findErrorBubble(saveName_l, mask_mm, deg_from_zero, mm_from_zero, saveName_b); 
		
		pass = false; 
		if abs(distance_degrees) < tolerance
			pass = true; 
		end
		
		data = strcat(images(i), ' = ', num2str(distance_degrees), ', ', num2str(distance_mm), ', ', mat2str(pass)); 
		saveDataString = [saveDataString data newline]; 
	end
	
	saveData(saveResultsTo, saveDataString);
end
